﻿using System;
using Microsoft.SharePoint;

class Program
{
   static void Main(string[] args)
   {
      using (SPSite site = new SPSite("http://contoso.de"))
      {
         using (SPWeb web = site.OpenWeb())
         {
            SPSiteDataQuery query = new SPSiteDataQuery();

            // Setze den Bereich
            query.Webs = "<Webs Scope=\"SiteCollection\" />";

            // Setze den Listentyp (101=Dokumentbibliothek)
            query.Lists = "<Lists ServerTemplate=\"101\" />";

            // Hole den Titel und das Änderungsdatum
            query.ViewFields = String.Concat(
               "<FieldRef Name=\"FileLeafRef\" Type=\"File\"/>",
               "<FieldRef Name=\"Modified\" Type=\"DateTime\"/>");

            // Definiere die Sortierreihenfolge via CAML
            query.Query = String.Concat(
               "<OrderBy>",
               "   <FieldRef Name=\"Modified\" Ascending=\"FALSE\" />",
               "</OrderBy>");

            // Hole die Ergebnistabelle
            System.Data.DataTable allItems = web.GetSiteData(query);

            // Iteriere sämtliche Spalten der Tabelle und gebe den Dateinamen
            // und Feld des Änderungsdatums aus
            foreach (System.Data.DataRow row in allItems.Rows)
            {
               SPFieldLookupValue lookupFile =
                  new SPFieldLookupValue(row["FileLeafRef"]
                     .ToString());

               Console.WriteLine("{0} (Geändert: {1})",
                  lookupFile.LookupValue,
                  row["Modified"]);
            }
         }
      }
   }
}